package kom.itbeankit.nw.ethernet;

public class DataEvent extends java.util.EventObject
{
    private int dataType;
    private int dataSize;
    private int sourceHost;
    private int destinationHost;
    private boolean startBit;
    private boolean stopBit;
   
    public DataEvent(Object source,
                        int type,
                        int dataSize,
                        int srcHost,
                        int dstHost){
        super(source);
        this.dataType           = type;
        this.dataSize           = dataSize;
        this.sourceHost         = srcHost;
        this.destinationHost    = dstHost;
        this.startBit           = false;
        this.stopBit            = false;
    }
    public DataEvent(Object source,
                        int type,
                        int dataSize,
                        int srcHost,
                        int dstHost,
                        boolean startBit,
                        boolean stopBit){
        super(source);
        this.dataType           = type;
        this.dataSize           = dataSize;
        this.sourceHost         = srcHost;
        this.destinationHost    = dstHost;
        this.startBit           = startBit;
        this.stopBit            = stopBit;
    }
    
    public DataEvent(Object source,DataEvent e){
        super(source);
        this.dataType           = e.getDataType();
        this.dataSize           = e.getDataSize();
        this.sourceHost         = e.getSourceHost();
        this.destinationHost    = e.getDestinationHost();
        this.startBit           = e.hasStartBit();
        this.stopBit            = e.hasStopBit();
    }
    
    public int getDataType(){
        return dataType;
    }
    public int getDataSize(){
        return dataSize;
    }
    public int getSourceHost(){
        return sourceHost;
    }
    public int getDestinationHost(){
        return destinationHost;
    }
    public boolean hasStartBit(){
        return startBit;
    }
    
    public boolean hasStopBit(){
        return stopBit;
    }
    
}
